/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.spawning.influence;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.fishing.SpawnBait;
import com.cobblemon.mod.common.api.fishing.SpawnBaitUtils;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.pokemon.egg.EggGroup;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.api.spawning.detail.PokemonSpawnDetail;
import com.cobblemon.mod.common.api.spawning.detail.SpawnAction;
import com.cobblemon.mod.common.api.spawning.detail.SpawnDetail;
import com.cobblemon.mod.common.api.spawning.influence.SpawningInfluence;
import com.cobblemon.mod.common.api.spawning.position.SpawnablePosition;
import com.cobblemon.mod.common.api.types.ElementalTypes;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Species;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1297;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0010\b\u0016\u0018\u00002\u00020\u0001BQ\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012:\b\u0002\u0010\r\u001a4\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0015\u0012\u0013\u0018\u00010\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0005\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001b\u0010\u0010\u001a\u00020\f2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J#\u0010\u0015\u001a\u00020\f2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u000b\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J'\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001f\u001a\u0004\b \u0010!RI\u0010\r\u001a4\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0015\u0012\u0013\u0018\u00010\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u00058\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\"\u001a\u0004\b#\u0010$R\"\u0010%\u001a\u00020\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*\u00a8\u0006+"}, d2={"Lcom/cobblemon/mod/common/api/spawning/influence/SpawnBaitInfluence;", "Lcom/cobblemon/mod/common/api/spawning/influence/SpawningInfluence;", "", "Lcom/cobblemon/mod/common/api/fishing/SpawnBait$Effect;", "effects", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "time", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "entity", "", "onUsed", "<init>", "(Ljava/util/List;Lkotlin/jvm/functions/Function2;)V", "markUsed", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnAction;", "action", "Lnet/minecraft/class_1297;", "affectSpawn", "(Lcom/cobblemon/mod/common/api/spawning/detail/SpawnAction;Lnet/minecraft/class_1297;)V", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnDetail;", "detail", "Lcom/cobblemon/mod/common/api/spawning/position/SpawnablePosition;", "spawnablePosition", "", "weight", "affectWeight", "(Lcom/cobblemon/mod/common/api/spawning/detail/SpawnDetail;Lcom/cobblemon/mod/common/api/spawning/position/SpawnablePosition;F)F", "Ljava/util/List;", "getEffects", "()Ljava/util/List;", "Lkotlin/jvm/functions/Function2;", "getOnUsed", "()Lkotlin/jvm/functions/Function2;", "usedTimes", "I", "getUsedTimes", "()I", "setUsedTimes", "(I)V", "common"})
@SourceDebugExtension(value={"SMAP\nSpawnBaitInfluence.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpawnBaitInfluence.kt\ncom/cobblemon/mod/common/api/spawning/influence/SpawnBaitInfluence\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,127:1\n1869#2,2:128\n1761#2,3:130\n295#2,2:134\n1761#2,3:136\n295#2,2:139\n1761#2,3:141\n774#2:144\n865#2,2:145\n295#2,2:147\n1#3:133\n*S KotlinDebug\n*F\n+ 1 SpawnBaitInfluence.kt\ncom/cobblemon/mod/common/api/spawning/influence/SpawnBaitInfluence\n*L\n44#1:128,2\n58#1:130,3\n61#1:134,2\n79#1:136,3\n82#1:139,2\n98#1:141,3\n104#1:144\n104#1:145,2\n107#1:147,2\n*E\n"})
public class SpawnBaitInfluence
implements SpawningInfluence {
    @NotNull
    private final List<SpawnBait.Effect> effects;
    @NotNull
    private final Function2<Integer, PokemonEntity, Unit> onUsed;
    private int usedTimes;

    public SpawnBaitInfluence(@NotNull List<SpawnBait.Effect> effects, @NotNull Function2<? super Integer, ? super PokemonEntity, Unit> onUsed) {
        Intrinsics.checkNotNullParameter(effects, (String)"effects");
        Intrinsics.checkNotNullParameter(onUsed, (String)"onUsed");
        this.effects = effects;
        this.onUsed = onUsed;
    }

    public /* synthetic */ SpawnBaitInfluence(List list, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function2 = SpawnBaitInfluence::_init_$lambda$0;
        }
        this(list, (Function2<? super Integer, ? super PokemonEntity, Unit>)function2);
    }

    @NotNull
    public final List<SpawnBait.Effect> getEffects() {
        return this.effects;
    }

    @NotNull
    public final Function2<Integer, PokemonEntity, Unit> getOnUsed() {
        return this.onUsed;
    }

    public final int getUsedTimes() {
        return this.usedTimes;
    }

    public final void setUsedTimes(int n) {
        this.usedTimes = n;
    }

    private final void markUsed(PokemonEntity entity) {
        int n = this.usedTimes;
        this.usedTimes = n + 1;
        this.onUsed.invoke((Object)this.usedTimes, (Object)entity);
    }

    static /* synthetic */ void markUsed$default(SpawnBaitInfluence spawnBaitInfluence, PokemonEntity pokemonEntity, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: markUsed");
        }
        if ((n & 1) != 0) {
            pokemonEntity = null;
        }
        spawnBaitInfluence.markUsed(pokemonEntity);
    }

    @Override
    public void affectSpawn(@NotNull SpawnAction<?> action, @NotNull class_1297 entity) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (entity instanceof PokemonEntity) {
            List<SpawnBait.Effect> merged = SpawnBaitUtils.mergeEffects(this.effects);
            Iterable $this$forEach$iv = merged;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SpawnBait.Effect effect = (SpawnBait.Effect)element$iv;
                boolean bl = false;
                if (!(Math.random() <= effect.getChance())) continue;
                this.markUsed((PokemonEntity)entity);
                Function2<PokemonEntity, SpawnBait.Effect, Unit> function2 = SpawnBait.Effects.INSTANCE.getEffectFunction(effect.getType());
                if (function2 != null) {
                    function2.invoke((Object)entity, (Object)effect);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float affectWeight(@NotNull SpawnDetail detail, @NotNull SpawnablePosition spawnablePosition, float weight) {
        boolean bl;
        Species detailSpecies;
        block42: {
            boolean bl2;
            Object it;
            String it2;
            SpawnBait.Effect it3;
            Iterable $this$any$iv;
            List<SpawnBait.Effect> merged;
            block40: {
                boolean bl3;
                boolean $i$f$any;
                block38: {
                    Intrinsics.checkNotNullParameter((Object)detail, (String)"detail");
                    Intrinsics.checkNotNullParameter((Object)spawnablePosition, (String)"spawnablePosition");
                    merged = SpawnBaitUtils.mergeEffects(this.effects);
                    $this$any$iv = merged;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it3 = (SpawnBait.Effect)element$iv;
                            boolean bl4 = false;
                            if (!Intrinsics.areEqual((Object)it3.getType(), (Object)SpawnBait.Effects.INSTANCE.getEV())) continue;
                            bl3 = true;
                            break block38;
                        }
                        bl3 = false;
                    }
                }
                if (bl3 && detail instanceof PokemonSpawnDetail) {
                    Stats baitEVStat;
                    Object object;
                    Object v3;
                    block39: {
                        Species species;
                        String string = ((PokemonSpawnDetail)detail).getPokemon().getSpecies();
                        if (string != null) {
                            it2 = string;
                            boolean bl5 = false;
                            species = PokemonSpecies.getByName(it2);
                        } else {
                            species = null;
                        }
                        detailSpecies = species;
                        Iterable $this$firstOrNull$iv = this.effects;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            SpawnBait.Effect it4 = (SpawnBait.Effect)element$iv;
                            boolean bl6 = false;
                            if (!Intrinsics.areEqual((Object)it4.getType(), (Object)SpawnBait.Effects.INSTANCE.getEV())) continue;
                            v3 = element$iv;
                            break block39;
                        }
                        v3 = null;
                    }
                    if ((object = (SpawnBait.Effect)v3) != null && (object = ((SpawnBait.Effect)object).getSubcategory()) != null && (object = object.method_12832()) != null) {
                        it = object;
                        boolean bl7 = false;
                        v5 = Stats.Companion.getStat((String)it);
                    } else {
                        v5 = baitEVStat = null;
                    }
                    if (detailSpecies != null && baitEVStat != null) {
                        float f;
                        Integer n = detailSpecies.getEvYield().get(baitEVStat);
                        float evYieldValue = n != null ? (float)n.intValue() : 0.0f;
                        if (evYieldValue > 0.0f) {
                            SpawnBaitInfluence.markUsed$default(this, null, 1, null);
                            f = SpawningInfluence.super.affectWeight(detail, spawnablePosition, weight);
                        } else {
                            SpawnBaitInfluence.markUsed$default(this, null, 1, null);
                            f = SpawningInfluence.super.affectWeight(detail, spawnablePosition, 0.0f);
                        }
                        return f;
                    }
                }
                $this$any$iv = merged;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it3 = (SpawnBait.Effect)element$iv;
                        boolean bl8 = false;
                        if (!Intrinsics.areEqual((Object)it3.getType(), (Object)SpawnBait.Effects.INSTANCE.getTYPING())) continue;
                        bl2 = true;
                        break block40;
                    }
                    bl2 = false;
                }
            }
            if (bl2 && detail instanceof PokemonSpawnDetail) {
                Iterator baitTypingEffect;
                SpawnBait.Effect baitEffect;
                Object object;
                Object v11;
                block41: {
                    Species species;
                    String string = ((PokemonSpawnDetail)detail).getPokemon().getSpecies();
                    if (string != null) {
                        it2 = string;
                        boolean bl9 = false;
                        species = PokemonSpecies.getByName(it2);
                    } else {
                        species = null;
                    }
                    detailSpecies = species;
                    Iterable $this$firstOrNull$iv = this.effects;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        it = (SpawnBait.Effect)element$iv;
                        boolean bl10 = false;
                        if (!Intrinsics.areEqual((Object)((SpawnBait.Effect)it).getType(), (Object)SpawnBait.Effects.INSTANCE.getTYPING())) continue;
                        v11 = element$iv;
                        break block41;
                    }
                    v11 = null;
                }
                if ((object = (baitEffect = (SpawnBait.Effect)v11)) != null && (object = ((SpawnBait.Effect)object).getSubcategory()) != null && (object = object.method_12832()) != null) {
                    it = object;
                    boolean bl11 = false;
                    v13 = ElementalTypes.get((String)it);
                } else {
                    v13 = baitTypingEffect = null;
                }
                if (detailSpecies != null && baitTypingEffect != null) {
                    float f;
                    boolean isMatchingType = CollectionsKt.contains(detailSpecies.getTypes(), baitTypingEffect);
                    if (isMatchingType) {
                        SpawnBaitInfluence.markUsed$default(this, null, 1, null);
                        f = SpawningInfluence.super.affectWeight(detail, spawnablePosition, weight * (float)baitEffect.getValue());
                    } else {
                        f = SpawningInfluence.super.affectWeight(detail, spawnablePosition, weight);
                    }
                    return f;
                }
            }
            $this$any$iv = merged;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it3 = (SpawnBait.Effect)element$iv;
                    boolean bl12 = false;
                    if (!Intrinsics.areEqual((Object)it3.getType(), (Object)SpawnBait.Effects.INSTANCE.getEGG_GROUP())) continue;
                    bl = true;
                    break block42;
                }
                bl = false;
            }
        }
        if (bl && detail instanceof PokemonSpawnDetail) {
            String string = ((PokemonSpawnDetail)detail).getPokemon().getSpecies();
            if (string != null) {
                String it = string;
                boolean bl13 = false;
                v17 = PokemonSpecies.getByName(it);
            } else {
                v17 = detailSpecies = null;
            }
            if (detailSpecies != null) {
                Object v20;
                block43: {
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = this.effects;
                    boolean $i$f$filter = false;
                    Iterable bl13 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        SpawnBait.Effect it = (SpawnBait.Effect)element$iv$iv;
                        boolean bl14 = false;
                        if (!Intrinsics.areEqual((Object)it.getType(), (Object)SpawnBait.Effects.INSTANCE.getEGG_GROUP())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List eggGroupEffects = (List)destination$iv$iv;
                    Iterable $this$firstOrNull$iv = eggGroupEffects;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        boolean bl15;
                        SpawnBait.Effect effect = (SpawnBait.Effect)element$iv;
                        boolean bl16 = false;
                        Object object = effect.getSubcategory();
                        if (object == null || (object = object.method_12832()) == null) {
                            bl15 = false;
                        } else {
                            Object effectEggGroupKey = object;
                            EggGroup eggGroup = EggGroup.Companion.fromIdentifier((String)effectEggGroupKey);
                            if (eggGroup == null) {
                                Cobblemon.LOGGER.warn("Unknown egg group identifier: " + (String)effectEggGroupKey);
                                bl15 = false;
                            } else {
                                bl15 = detailSpecies.getEggGroups().contains((Object)eggGroup);
                            }
                        }
                        if (!bl15) continue;
                        v20 = element$iv;
                        break block43;
                    }
                    v20 = null;
                }
                SpawnBait.Effect matchingEffect = v20;
                if (matchingEffect != null) {
                    SpawnBaitInfluence.markUsed$default(this, null, 1, null);
                    double multiplier = matchingEffect.getValue();
                    return SpawningInfluence.super.affectWeight(detail, spawnablePosition, (float)((double)weight * multiplier));
                }
            }
        }
        return SpawningInfluence.super.affectWeight(detail, spawnablePosition, weight);
    }

    private static final Unit _init_$lambda$0(int n, PokemonEntity pokemonEntity) {
        return Unit.INSTANCE;
    }
}

